
# Accelerometer Vector Magnitude App Note Example

import FXOS8700CQ
import aardvark_setup
from aardvark_py import *
import time
import math
from config import *

# Print Revision

print "AN4458 SW Rev: " + str(REVISION)

# Setup Aardvark

(handle, INT1_PIN) = aardvark_setup.setup_aardvark()

# Update aardvark handle in FXOS8700CQ.py

FXOS8700CQ.handle = handle

# Reset 

FXOS8700CQ.reset_FXOS8700CQ()

# 0.3G
# A_VECM_THS_MSB, LSB  = 0x84CC => 1228 *0.224mg = ~300mg
# 0x8000 designates the debounce behavior

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x60, 0x84] ) # write 0x84 to reg 0x60
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x61, 0xCC] )

# A_VECM_CNT = 1 * 20ms  = 20ms
# ! - steps double in hybrid mode

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x62, 0x01] )

# A_VECM_INITX/Y/Z
# Set Z only as 1g

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x63, 0x00] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x64, 0x00] )

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x65, 0x00] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x66, 0x00] )

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x67, 0x10] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x68, 0x00] )

# A_VECM_CFG
# a_vecm_ele = 1 => event latching enabled
# a_vecm_initm = 1 => use A_VECM_INITX/Y/Z as initial reference
# a_vecm_updm = 1 => do not update initial reference
# a_vecm_en = 1 => enable acceleration vector magnitude detection feature

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x5F, 0x78] )

# enable interrupts for the feature using CTRL_REG4

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2D, 0x02] )

# route interrupts to INT1 pin using CTRL_REG5
    
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2E, 0x02] )

# Setup device for hybrid mode, enable hybrid mode auto-increment, 
# ODR = 6.25Hz, OSR=256, go to ACTIVE mode using M_CTRL_REG1, M_CTRL_REG2 and
# CTRL_REG1

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x5B, 0x1F] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x5C, 0x20] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2A, 0x29] )

# Wait for INT1 to assert and clear interrupt by reading register 
# INT_SOURCE (0x0C)		

while( True ):
            
    transition = aa_gpio_change( handle, 100 )

    if (transition & INT1_PIN ) == INT1_PIN:
        print "No interrupt..."
        continue

    print "Interrupt occured!!!"
    (count, dataIn) = FXOS8700CQ.read_FXOS8700CQ( 0x0C, 1 ) 
    print "0x0C =0x%X" % dataIn[0]
